package reseauSocial.core;


import java.util.Collection;
import java.util.Observer;
import java.util.Set;

import facebookGhost.FacebookGhostNetwork;

/**
 * 
 * Interface "basique" de dfinition d'un rseau social
 * 
 * @author blay
 *
 */
/**
 * @author blay
 *
 */
public interface ReseauSocialInterface extends Observer{

	/**
	 * @param identifiant d'un membre
	 * @return le membre dans le rseau social s'il est connu du rseau.
	 */
	public MembreInterface  getMembre(String identifiant);

	/**
	 * @return l'ensemble des membres du rseau
	 */
	public Collection<? extends MembreInterface> getMembres();

	/**
	 * @param identifiant
	 * @param age
	 * @param description
	 * @return Membre cr et ajout au rseau
	 */
	public MembreInterface addMembre(String identifiant, int age, String description);
	
	
	/**
	 * @param identifiant
	 * @param autreReseau prcise si le nouveau membre fait partie d'un autre rseau. Dans ce cas la cration du membre devra faire le lien avec 
	 * ce membre dans l'autre rseau
	 * @return  Membre cr et ajout au rseau
	 */
	public MembreInterface addMembre(String identifiant, boolean autreReseau);

	/**
	 * 
	 * Ajoute la relation entre membre et ami avec une force donne.
	 * 
	 * @param force
	 * @param membre
	 * @param ami
	 * 
	 */
	public void mettreEnRelation(int force, MembreInterface membre, MembreInterface ami);

	/**
	 * @param membre
	 * @param rang
	 * @return l'ensemble des membres au rang donn (au rang 1, les voisins directs, au rang 2, les voisins des voisins.
	 * Un membre apparait au rang le plus petit, il n'apparait pas dans un rang suprieur
	 */
	public Set<? extends MembreInterface> membresEnRelationAuRang(MembreInterface membre, int rang);

	/**
	 * @param membre1
	 * @param membre2
	 * @return la distance entre les 2 membres
	 */
	public int distance(MembreInterface membre1, MembreInterface membre2);

	/**
	 * Fixe le rseau secondaire auquel on peut se connecter.
	 * Il vous est donn.
	 * @param f
	 */
	public void setAutreReseau(FacebookGhostNetwork f);



}
