package reseauSocialTests;

import static org.junit.Assert.*;
import facebookGhost.FacebookGhostNetwork;

import java.util.Collection;
import java.util.Set;

import org.junit.Test;

//Cette classe correspond  mon implmentation.
// Vous devez la remplacer par votre propre classe.
import reseauSocial.ReseauSocial;

import reseauSocial.core.MembreInterface;
import reseauSocial.core.ReseauSocialInterface;




public class MainScenario {

	//Unique rfrence  modifier.
	ReseauSocialInterface iutRS = new ReseauSocial("IUT");
	
	@Test
	public void test() {
		assertTrue(iutRS != null);
		iutRS.addMembre("geek01",18,"S1T, le plus beau");
		MembreInterface m_geek01 = iutRS.getMembre("geek01");
		assertEquals("geek01",m_geek01.identifiant());
		assertEquals(18,m_geek01.getAge());
		assertEquals("S1T, le plus beau",m_geek01.getDescription());	
		iutRS.addMembre("ivana",Integer.MIN_VALUE, "Princesse Geek");
		Collection<? extends MembreInterface> membres = iutRS.getMembres();
		assertEquals("taille du reseau est bien de 2 membres", 2,membres.size());
		//------------ Construction des relations ------- //
		MembreInterface asterix = iutRS.addMembre("Asterix",0,"Asterix, le plus intelligent");
		iutRS.addMembre("Falbala",0,"falbala, la plus jolie");
		iutRS.addMembre("Obelix",0,"Obelix, le plus intelligent");
		iutRS.addMembre("Panoramix",0,"Panoramix, le plus magique");
		iutRS.addMembre("Abraracourcix",0,"Abraracourcix, chef du village");
		MembreInterface obelix = iutRS.getMembre("Obelix");
		MembreInterface panoramix = iutRS.getMembre("Panoramix");
		MembreInterface falbala = iutRS.getMembre("Falbala");
		MembreInterface abraracourcix = iutRS.getMembre("Abraracourcix");
		
		iutRS.mettreEnRelation(1, asterix, obelix);
		iutRS.mettreEnRelation(1, asterix, panoramix);
		iutRS.mettreEnRelation(1, obelix, asterix);
		iutRS.mettreEnRelation(2, obelix, falbala);
		iutRS.mettreEnRelation(3, obelix, panoramix);
		iutRS.mettreEnRelation(4, falbala, obelix);
		iutRS.mettreEnRelation(4, falbala, asterix);
		iutRS.mettreEnRelation(4, panoramix,abraracourcix);
		
		//tests au rang 1
		Set<? extends MembreInterface> membresAmis =  iutRS.membresEnRelationAuRang(asterix, 1);
		//System.out.println("Amis de Asterix" + membresAmis);
		assertEquals("taille des amis d'Asterix au rang 1 : 2 membres", 2, membresAmis.size());
		assertTrue("Asterix est bien ami d'Obelix", membresAmis.contains(obelix));
		membresAmis = iutRS.membresEnRelationAuRang(panoramix, 1);
		//System.out.println("Amis de Panoramix" + membresAmis);
		assertEquals("taille des amis de Panoramix au rang 1 : 1 membres", 1, membresAmis.size());
		
		//tests au rang 2
		membresAmis = iutRS.membresEnRelationAuRang(asterix, 2);
		//System.out.println("Amis de Asterix au rang 2" + membresAmis);
		assertEquals("taille des amis d'Asterix au rang 2 : 2 membre Falbala et Abraracourcix, les autres le sont deja au rang 1", 2, membresAmis.size());
		assertTrue("Asterix est bien ami de falbala au rang 2", membresAmis.contains(falbala));
		membresAmis = iutRS.membresEnRelationAuRang(panoramix, 2);
		assertEquals("taille des amis de Panoramix au rang 2 : 0 membres", 0, membresAmis.size());
		membresAmis = iutRS.membresEnRelationAuRang(obelix, 2);
		//System.out.println("Amis de Obelix au rang 2" + membresAmis);
		assertEquals("taille des amis Obelix au rang 2 : 1 membre", 1, membresAmis.size());
		membresAmis = iutRS.membresEnRelationAuRang(falbala, 3);
		assertEquals("taille des amis Falbala au rang 3 : 1 membre", 1, membresAmis.size());
		assertTrue("Abraracourcix est bien ami de falbala au rang 3", membresAmis.contains(abraracourcix));
		
		//Calcul des distances
		int distance = iutRS.distance(asterix,obelix);
		assertEquals("distance entre asterix et obelix", 1, distance);
		distance = iutRS.distance(asterix,falbala);
		assertEquals("distance entre asterix et falbala", 3, distance);
		distance = iutRS.distance(falbala,asterix);
		assertEquals("distance entre falbala et asterix", 4, distance);
		distance = iutRS.distance(falbala,abraracourcix);
		assertEquals("distance entre falbala et Abraracourcix", 9, distance);
		
		
		//------------ Connexions  FG ------- //
		FacebookGhostNetwork fg = new FacebookGhostNetwork();
		//System.out.println(fg);
		iutRS.setAutreReseau(fg);
		iutRS.addMembre("Admte",true);
		MembreInterface admete = iutRS.getMembre("Admte");
		assertEquals("description de Ademete", 
				admete.getDescription(), 
				fg.getUser("Admte").myProfil());
		membresAmis = iutRS.membresEnRelationAuRang(admete, 1);
		assertEquals("taille des amis d'ADMETE au rang 1 : 0 membres", 0, membresAmis.size());
		
		MembreInterface zeus = iutRS.addMembre("Zeus",true);
		membresAmis = iutRS.membresEnRelationAuRang(admete, 1);
		assertEquals("taille des amis de Zeus au rang 1 : 0 membres", 0, membresAmis.size());

		MembreInterface hera = iutRS.addMembre("Hera",true);
		membresAmis = iutRS.membresEnRelationAuRang(hera, 1);
		//System.out.println("amis Hera au rang 1" + membresAmis);
		assertEquals("taille des amis Hera au rang 1 : 1 membres", 0, membresAmis.size());

		iutRS.addMembre("Hercule",true);
		MembreInterface hercule = iutRS.getMembre("Hercule");
		membresAmis = iutRS.membresEnRelationAuRang(hercule, 1);
		//System.out.println("relations de hercule" + membresAmis);
		assertEquals("taille des amis d'Hercule au rang 1 : 2 membre", 2, membresAmis.size());
		assertTrue("Zeus est bien ami de Hercule au rang 1", membresAmis.contains(zeus));
		assertTrue("Admete est bien ami de Hercule au rang 1", membresAmis.contains(admete));
		distance = iutRS.distance(hercule,zeus);
		assertEquals("distance entre hercule et zeus", 2, distance);
		distance = iutRS.distance(hercule,admete);
		assertEquals("distance entre hercule et admete", 3, distance);

		membresAmis = iutRS.membresEnRelationAuRang(hercule, 2);
		//System.out.println("amis d'Hercule au rang 2" + membresAmis);
		assertEquals("taille des amis d'Hercule au rang 2 : 0 membre", 0, membresAmis.size());

		
		membresAmis = iutRS.membresEnRelationAuRang(admete, 1);
		//System.out.println("amis d'ADMETE au rang 1" + membresAmis);
		assertEquals("taille des amis d'ADMETE au rang 1 : 1 membres", 1, membresAmis.size());
		distance = iutRS.distance(admete,hercule);
		assertEquals("distance entre hercule et admete", 3, distance);
		
		//------------ Observations  : Connexions  FG ------- //
		fg.addObserver(iutRS);
				fg.addFamilyRelation("Zeus", "Hera");
		membresAmis = iutRS.membresEnRelationAuRang(hera, 1);
		assertEquals("taille des amis Hera au rang 1 : 1 membres", 1, membresAmis.size());
		membresAmis = iutRS.membresEnRelationAuRang(hercule, 1);
		assertEquals("taille des amis d'Hercule au rang 1 : 2 membre", 2, membresAmis.size());
		membresAmis = iutRS.membresEnRelationAuRang(hercule, 2);
		assertEquals("taille des amis d'Hercule au rang 2 : 1membre", 1, membresAmis.size());
		
		//Non demand
		//fg.addUser("Asterix", "Albert Uderzo, Astrix est le seul anti-hros qui ait jamais autant collectionn les succs et les exploits.");
		//assertEquals("description de Asterix", asterix.getDescription(), fg.getUser("Asterix").myProfil());
		
		
	}

}
