package fr.unice.iut.library.services;

import fr.unice.iut.library.Book;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import java.util.List;

public interface LibraryService {

    @GET
    @Path("/")
    @Produces(MediaType.APPLICATION_JSON)
    List<Book> getAllBooks();

    @GET
    @Path("/{isbn}")
    @Produces(MediaType.APPLICATION_JSON)
    Response getBook(@PathParam("isbn") String isbn);

    @Path("/")
    @POST
    @Consumes(MediaType.APPLICATION_JSON)
    public Response createBook(String bookJSON);
}
