'use strict';

/**
 * @ngdoc service
 * @name ShapesWSClientService
 * @description Service used to query the shapes WS.
 */
angular.module('geoCatchingApp')
  .service('ShapesWSClientService', ['$http', '$q', function ($http, $q) {
    /**
     * @ngdoc function
     * @name getAllShapes
     * @description retrieve a json description of available shapes
     * @returns Function, a promise containing the JSON data returned by the WS
     */
    this.getAllShapes = function (url) {
      var deferred = $q.defer();
      $http.get(url)
        .success(function (data) {
          deferred.resolve(data);
        })
        .error(function (error, status) {
          if (status === -1) {
            deferred.reject('Unable to connect to shapes WS at ' + url);
          } else {
            deferred.reject('Error while getting shapes list (status ' + status + ')');
          }
        });
      return deferred.promise;
    };

  }]);
