'use strict';

/**
 * @ngdoc function
 * @name todoListApp.controller:MainCtrl
 * @description
 * # MainCtrl
 * Controller of the todoListApp
 */
angular.module('geoCatchingApp')
  .controller('MainCtrl', ['$scope', '$rootScope', 'JsonLoaderService', 'ShapesWSClientService',
    function ($scope, $rootScope, JsonLoaderService, ShapesWSClient) {

      /* Scope: accessible depuis le html */
      $scope.someNumber = 12;

      $scope.getSomeNumber = function () {
        return $scope.someNumber;
      };

      $scope.incrementNumber = function () {
        $scope.someNumber++;
      };

      function init() {
        //Chargement du fichier de configuration. Sauvegarde dans $rootScope pour rendre accessible partout.
        JsonLoaderService.loadJSON('config')
          .then(function (data) {
            // On a bien reussi a charger le fichier
            $rootScope.teamId = data.teamId;
            $rootScope.shapesWSUrl = data.shapesWSUrl;
            loadShapesFromWS(); // Appel au service web de formes
          }, function (error) {
            // Erreur
            $scope.error = error;
          });
      }

      function loadShapesFromWS() {
        ShapesWSClient.getAllShapes($rootScope.shapesWSUrl)
          .then(function (data) {
            // La requete a fonctionne. On sauvegarde seulement pour ce contexte.
            $scope.shapes = data;
          }, function (error) {
            // Erreur
            $scope.error = error;
          });
      }

      init();

    }]);
