'use strict';

/**
 * @ngdoc service
 * @name JsonLoaderService
 * @description Service used to retrieve a .json files locally stored
 */
angular.module('geoCatchingApp')
  .service('JsonLoaderService', ['$http', '$q', function ($http, $q) {
    /**
     * @ngdoc function
     * @name loadJSON
     * @description retrieve a json file local repository
     * @returns Function, a promise containing the data from the .json file
     */
    this.loadJSON = function (file) {
      var deferred = $q.defer();
      $http.get('./resources/' + file + '.json')
        .success(function (data) {
          deferred.resolve(data);
        })
        .error(function () {
          deferred.reject('File could not be loaded');
        });
      return deferred.promise;
    };

  }]);
