'use strict';

/**
 * @ngdoc controller
 * @name NavbarCtrl
 * @description Controller of the navigation bar.
 */

angular.module('geoCatchingApp')
  .controller('NavbarCtrl', ['$scope', '$location', function ($scope, $location) {


    /**
     * @ngdoc function
     * @name isActive
     * @description checks if the string in parameter matches the location of the page
     * used to change hover in navigation bar links
     * @param viewLocation is a string indicating the path of the view (suffix of URL) ex: /about
     * @returns boolean, true if the location in parameter and the location path matches
     */
    $scope.isActive = function (viewLocation) {
      return viewLocation === $location.path();
    };


  }]);
