/** HTTP REQUESTS **/
function httpGetAsync(url, status, successCallback, failureCallback) {
    var xmlHttp = new XMLHttpRequest();
    xmlHttp.onreadystatechange = function() { 
        if (xmlHttp.readyState == 4) {
            if (xmlHttp.status == status) {
                successCallback(xmlHttp.responseText);
            } else {
                failureCallback(xmlHttp.status, xmlHttp.responseText);
            }
        }
    }
    xmlHttp.open("GET", url, true); // true for asynchronous 
    xmlHttp.send(null);
}

function httpDeleteAsync(url, status, successCallback, failureCallback) {
    var xmlHttp = new XMLHttpRequest();
    xmlHttp.onreadystatechange = function() { 
        if (xmlHttp.readyState == 4) {
            if (xmlHttp.status == status) {
                successCallback(xmlHttp.responseText);
            } else {
                failureCallback(xmlHttp.status, xmlHttp.responseText);
            }
        }
    }
    xmlHttp.open("DELETE", url, true); // true for asynchronous 
    xmlHttp.send(null);
}

function httpPostAsync(url, param, status, successCallback, failureCallback) {
    var xmlHttp = new XMLHttpRequest();
    xmlHttp.onreadystatechange = function() { 
        if (xmlHttp.readyState == 4) {
            if (xmlHttp.status == status) {
                successCallback(xmlHttp.responseText);
            } else {
                failureCallback(xmlHttp.status, xmlHttp.responseText);
            }
        }
    }
    var json = JSON.stringify(param);
    xmlHttp.open("POST", url, true); // true for asynchronous
    xmlHttp.setRequestHeader("Content-Type","application/json");
    xmlHttp.send(json);
}

/** MAP RELATED **/

var map;

// This function draws a polygon with the given vertices and color
function drawPolygon(vertices, color) {
	var polygon = new google.maps.Polygon({
        paths: vertices,
        strokeColor: color,
        strokeOpacity: 0.8,
        strokeWeight: 2,
        fillColor: color,
        fillOpacity: 0.35
    });
    polygon.setMap(map);
}

/** SHAPES WS - RELATED **/

// Retrieves the vertices for a given polygon from the WS and displays it.
function getShape(id, lat, lng, length, rot, color, question, expected) {
    var url = "http://localhost:8080/rest/shapes/" + id + "?lat=" + lat + "&lng=" + lng + "&length=" + length;
    if (rot !== 0) {
        url += "&rot=" + rot;
    }
    httpGetAsync(url, 200, function(res) {
        try {
            var json = JSON.parse(res);
            drawPolygon(json.vertices, color);
            if (res !== expected) {
                throw "invalid response from ws";
            }
            finishQuestion(question, true);
        } catch(e) {
            console.error(e);
            finishQuestion(question, false);
        }
    }, function (status, error) {
        finishQuestion(question, false);
        errorStatus(question, status, error);
    });
}

function deleteShape(shape, expectedStatus, question) {
    var url = "http://localhost:8080/rest/shapes/" + shape;
    httpDeleteAsync(url, expectedStatus, 
        function(res) {
            finishQuestion(question, true);
        }, function(status, error) {
            finishQuestion(question, false);
            errorStatus(question, status, error);
        });
}

function createAndDisplayShape(question) {
    var json = JSON.parse('{"id":"new","points":[{"x":0,"y":0},{"x":1,"y":0},{"x":0,"y":1}]}');
    var url = "http://localhost:8080/rest/shapes";
    httpPostAsync(url, json, 201, function(res) {
        getShape("new",35,-55,20,0,'#0077FF', question, newShape);
    }, function (status, error) {
        finishQuestion(question, false);
        errorStatus(question, status, error);
    });
}

function getAllShapes() {
    var url = "http://localhost:8080/rest/shapes";
    httpGetAsync(url, 200, function(res) {
        validateAllShapes(res);
    }, function(status, error) {
        finishQuestion(1, false);
        errorStatus(1, status, error);
    });
}

function getQuestion(url, expectedStatus, question) {
    httpGetAsync(url, expectedStatus, function(res) {
        finishQuestion(question, true);
    }, function(status, error) {
        finishQuestion(question, false);
        errorStatus(question, status, error);
    });
}

function addQuestion(shape, expectedStatus, question) {
    var json = JSON.parse(shape);
    var url = "http://localhost:8080/rest/shapes";
    httpPostAsync(url, json, 400, function(res) {
        finishQuestion(question, true);
    }, function (status, error) {
        finishQuestion(question, false);
        errorStatus(question, status, error);
    });
}

// Display the map and calls the WS
function initMap() {
    //create the map
    map = new google.maps.Map(document.getElementById('map'), {
        zoom: 2,
        center: {lat: 43.615505, lng: 7.072638},
        mapTypeId: google.maps.MapTypeId.TERRAIN
    });
  
    // Question 1 - get all shapes
    getAllShapes();
    // Question 2
    getShape("square",55,15,10,0,'#FF0000', 2, square);
    getShape("france",51.615505,2.072638,0.0001,0,'#0000FF', 2, france);
    // Questions 3 et 4 (add then delete)
    createAndDisplayShape(3);
    // Question 5
    getShape("square",25,15,10,45,'#00FF00', 5, squareRot);
    getShape("star",55,-105,10,180,'#FF7700', 5, star);
    
    // Question 6 - get non existing shape
    getQuestion("http://localhost:8080/rest/shapes/dontexist", 404, 6);
    // Question 7 - get shape wrong parameters
    getQuestion("http://localhost:8080/rest/shapes/square?lat=1&long=12&length=12&rot=0", 400, 7);
    // Question 8 - add already existing shape
    addQuestion('{"id":"square","points":[{"x":0,"y":0},{"x":1,"y":0},{"x":0,"y":1}]}', 400, 8);
    // Question 9 - add shape wrong parameters
    addQuestion('{"id":"inexisting","vertices":[{"x":0,"y":0},{"x":1,"y":0},{"x":0,"y":1}]}', 400, 9);
    // Question 10 - delete non existing shape
    deleteShape('inexist',404, 10);
}

/** Affichage du suivi du td **/

function validateAllShapes(res) {
    var success = true;
    try {
        allShapes = JSON.parse(res)
        allShapes.forEach(renderShapeList);
    } catch (e) {
        console.error(e.message);
        success = false;
    }
    finishQuestion(1, success);
}

function finishQuestion(id, success) {
    // Create shape -> delete
    if (id === 3) {
        deleteShape("new", 204, 4);
    }

    document.getElementById('inprogress' + id).className = "invisible";
    if (success) {
        document.getElementById('success' + id).className = "visible";
    } else {
        document.getElementById('fail' + id).className = "visible";
    }
}

function renderShapeList(element, index, arr) {
    var id = element.id;
    var vertices = element.vertices;
    if (id === undefined || vertices === undefined || element.length > 2) {
        throw "erreur de parsing de la reponse du web-service";
    }
    var li = document.createElement('li');
    document.getElementById('allshapes').appendChild(li);
    li.innerHTML = li.innerHTML + '<strong>' + id + '</strong> (' + vertices + ' vertices)';
}

function errorStatus(elementId, status, error) {
    console.log("Ex " + elementId + " failure: (" + status + ": " + error + ")");
}

/** expected results **/
var newShape ='{"vertices":[{"lng":-55.0,"lat":34.99999999999999},{"lng":-26.875,"lat":34.99999999999999},'
        + '{"lng":-55.0,"lat":9.23947369784686}]}';
var square = '{"vertices":[{"lng":15.0,"lat":54.999999999999986},{"lng":15.0,"lat":46.100292612185044},'
        + '{"lng":29.0625,"lat":46.100292612185044},{"lng":29.0625,"lat":54.999999999999986}]}';
var squareRot = '{"vertices":[{"lng":15.0,"lat":24.999999999999996},{"lng":5.056310889564173,"lat":15.689719290749037},'
        + '{"lng":15.0,"lat":5.935231790952672},{"lng":24.9436891104358,"lat":15.689719290749037}]}';
var star = '{"vertices":[{"lng":-105.0,"lat":54.999999999999986},{"lng":-107.8125,"lat":51.64223671462692},{"lng":-113.4375,"lat":51.64223671462692},{"lng":-109.21875,"lat":48.94813092462241},{"lng":-112.734375,"lat":44.11560447538535},{"lng":-105.0,"lat":46.58568313622587},{"lng":-97.265625,"lat":44.11560447538535},{"lng":-100.78125,"lat":48.94813092462241},{"lng":-96.5625,"lat":51.64223671462692},{"lng":-102.1875,"lat":51.64223671462692}]}';
var france = '{"vertices":[{"lng":2.072638000000012,"lat":51.61550499999998},{"lng":2.0709864715684034,"lat":51.61550915510873},{"lng":1.9092277504392996,"lat":51.605632194512324},{"lng":1.4853391899922315,"lat":51.458060557750514},{"lng":1.5103556745779656,"lat":51.377456712906145},{"lng":1.4651490042197963,"lat":51.28345952639919},{"lng":1.5172122320677204,"lat":50.86609278807547},{"lng":1.5172057731323605,"lat":50.865852937373674},{"lng":1.517203309814704,"lat":50.865762434514444},{"lng":1.4868818087483646,"lat":50.72468149782774},{"lng":1.3576935395422254,"lat":50.6382395002323},{"lng":1.2265029615870446,"lat":50.50662093302676},{"lng":1.2265001879301565,"lat":50.5064886810276},{"lng":1.2264959789542615,"lat":50.5062880140325},{"lng":0.9212891334910012,"lat":50.366495926854576},{"lng":0.4991735023053252,"lat":50.28658140865328},{"lng":0.24066338224827177,"lat":50.25994890719204},{"lng":-0.2632045452816101,"lat":50.07050486205536},{"lng":-0.36259126741470027,"lat":49.913212290641084},{"lng":-0.3578504864570675,"lat":49.83399098940567},{"lng":-0.11709974252369193,"lat":49.76674512374658},{"lng":-0.11726360164016114,"lat":49.762920304849295},{"lng":-0.11728740078029887,"lat":49.76236461489028},{"lng":-0.3973602982571265,"lat":49.680859412166406},{"lng":-0.5907075579673062,"lat":49.60499577357607},{"lng":-0.763457408639141,"lat":49.58575040107248},{"lng":-0.957529659596446,"lat":49.65592589007919},{"lng":-1.5670157271511016,"lat":49.72419912455711},{"lng":-1.6076194847571514,"lat":49.74764854181166},{"lng":-1.8456812749862195,"lat":49.696486889586204},{"lng":-1.8478856145777058,"lat":49.69655334661582},{"lng":-1.8483993229938562,"lat":49.696568828568886},{"lng":-2.0535726217719343,"lat":49.9282993941202},{"lng":-1.9595056572331657,"lat":50.029598501042386},{"lng":-1.998240338603324,"lat":50.12643938485019},{"lng":-2.249326232519877,"lat":50.13684494106303},{"lng":-2.29426323747839,"lat":50.09540530154098},{"lng":-2.4163718346805183,"lat":50.07972501882697},{"lng":-2.7943167272731557,"lat":50.19238818810281},{"lng":-2.709433961473195,"lat":50.05813887722311},{"lng":-2.735051883497789,"lat":49.92823741247125},{"lng":-2.660916068450632,"lat":49.759577210936264},{"lng":-2.5362841223188752,"lat":49.649608610774166},{"lng":-2.4790296561126866,"lat":49.55337143260678},{"lng":-2.441770618412278,"lat":49.29489001590778},{"lng":-2.457167595292475,"lat":49.13245094634651},{"lng":-2.396385309031558,"lat":48.92942900224486},{"lng":-2.3947806224283283,"lat":48.839274345380076},{"lng":-2.480081919480085,"lat":48.85287104204402},{"lng":-2.480781695664291,"lat":48.85289527821857},{"lng":-2.4824954083202897,"lat":48.85295466253978},{"lng":-2.64266011075739,"lat":48.81659351101485},{"lng":-2.8218254298839724,"lat":48.840337236864556},{"lng":-2.8011747976666754,"lat":48.94963003947688},{"lng":-2.8823150080569917,"lat":48.92893473418212},{"lng":-3.0050421501483413,"lat":48.80867146642154},{"lng":-2.9776776583011895,"lat":48.74142627032079},{"lng":-2.9777272349940915,"lat":48.74085485531932},{"lng":-2.977737476188878,"lat":48.74073680582145},{"lng":-2.9815825405273415,"lat":48.75226781568483},{"lng":-3.004553094305237,"lat":48.77073688679621},{"lng":-3.014224428663141,"lat":48.78282666513084},{"lng":-3.014912256786772,"lat":48.78288149322144},{"lng":-3.014884578406196,"lat":48.78319762903422},{"lng":-3.0733323377662316,"lat":48.873288086437036},{"lng":-3.19085313185775,"lat":48.87307926018466},{"lng":-3.163796593513439,"lat":48.835857748405886},{"lng":-3.1638195392206967,"lat":48.835603251616654},{"lng":-3.1638891909829,"lat":48.83483029299733},{"lng":-3.2684055491359914,"lat":48.80006160214552},{"lng":-3.308742725338533,"lat":48.85784011855629},{"lng":-3.4032146437875213,"lat":48.87168196827631},{"lng":-3.410845827405865,"lat":48.92635461547955},{"lng":-3.6096722233041305,"lat":48.89959926425812},{"lng":-3.928749506343138,"lat":48.81194760031081},{"lng":-4.0168809420552805,"lat":48.92338779526637},{"lng":-4.326757849922814,"lat":49.17089505047821},{"lng":-4.463978610171523,"lat":49.163801529246236},{"lng":-4.502304051070752,"lat":49.22078740094986},{"lng":-4.7631771716535525,"lat":49.145773371581235},{"lng":-4.889895043562149,"lat":49.18481530935515},{"lng":-4.960140096818378,"lat":49.022049808140395},{"lng":-5.041964934958941,"lat":48.99712192673061},{"lng":-5.043605504536288,"lat":48.997208436568485},{"lng":-5.044369326980274,"lat":48.99724872632989},{"lng":-5.381093740320637,"lat":49.036727811559},{"lng":-5.427304067163419,"lat":49.089095838161654},{"lng":-5.724506507284957,"lat":49.018591608635006},{"lng":-6.191220718492559,"lat":49.01078235828741},{"lng":-6.132604755266726,"lat":48.961425205097996},{"lng":-6.379708861015274,"lat":48.93521779424736},{"lng":-6.454803954036322,"lat":48.89541141946479},{"lng":-6.487508239754703,"lat":48.65913058037739},{"lng":-5.978202664513333,"lat":48.71908591656568},{"lng":-6.087232072813634,"lat":48.63102576796393},{"lng":-5.970837732563069,"lat":48.64695465045695},{"lng":-5.856596913854133,"lat":48.53093187593562},{"lng":-6.166202759795453,"lat":48.58098216249912},{"lng":-6.21962232527315,"lat":48.65638450186728},{"lng":-6.286414020495016,"lat":48.55152072327939},{"lng":-6.080428350578757,"lat":48.52161998790094},{"lng":-5.929640199018024,"lat":48.45875283917567},{"lng":-5.900045687007605,"lat":48.39435291346926},{"lng":-5.941800318273181,"lat":48.32955789654099},{"lng":-6.0211441106011705,"lat":48.35658365976361},{"lng":-6.408784873747521,"lat":48.32968156394633},{"lng":-6.502222412127594,"lat":48.30029648085236},{"lng":-6.29164730981978,"lat":48.23372045109441},{"lng":-6.222236196278601,"lat":48.28011336233816},{"lng":-6.081292936293352,"lat":48.133462887439805},{"lng":-6.0730610134994265,"lat":47.95903080340342},{"lng":-5.847351423116237,"lat":47.95443080190207},{"lng":-5.739938727064555,"lat":48.041181726272924},{"lng":-5.576914229173838,"lat":48.00732092064154},{"lng":-5.434543505685184,"lat":47.92105831616405},{"lng":-5.353024700823482,"lat":47.91725718570207},{"lng":-5.28781823781398,"lat":47.971265790666386},{"lng":-5.0365327181840485,"lat":47.8647162144681},{"lng":-5.00758609751685,"lat":47.91449331050287},{"lng":-5.007605396738057,"lat":47.91432553107642},{"lng":-5.007626325240267,"lat":47.91414335991163},{"lng":-4.928710626491807,"lat":47.77886282093813},{"lng":-4.736232433018898,"lat":47.770394666338284},{"lng":-4.655993680523636,"lat":47.70153885373459},{"lng":-4.60062609626695,"lat":47.80934121698539},{"lng":-4.532805257950741,"lat":47.7753782776095},{"lng":-4.6345990487810695,"lat":47.72654499429079},{"lng":-4.554681381017559,"lat":47.56697556843309},{"lng":-4.244097074258349,"lat":47.595791163448666},{"lng":-4.198300293843403,"lat":47.640224335616374},{"lng":-3.9919288916533446,"lat":47.61554129691395},{"lng":-4.058531823035082,"lat":47.53770757050596},{"lng":-4.134903360728913,"lat":47.53699210996882},{"lng":-4.175014668156422,"lat":47.475199097200544},{"lng":-3.7158759928629195,"lat":47.48211237052685},{"lng":-3.716346913256956,"lat":47.401080894832354},{"lng":-3.71326105506634,"lat":47.40094691777001},{"lng":-3.713179397054944,"lat":47.400943373051334},{"lng":-3.8432702297396304,"lat":47.3048926314978},{"lng":-3.728178984543746,"lat":47.239116669443874},{"lng":-3.791209600982853,"lat":47.205980279028154},{"lng":-3.631269079851137,"lat":47.18161574452727},{"lng":-3.533794803862122,"lat":47.120540033118516},{"lng":-3.369587467370593,"lat":47.15464167465057},{"lng":-3.3771358873939903,"lat":46.96464207063321},{"lng":-3.2249901956388953,"lat":46.91136739807439},{"lng":-3.2250524768442688,"lat":46.910624008958365},{"lng":-3.224700843093956,"lat":46.91060995039881},{"lng":-3.1999986933616356,"lat":46.89497506705678},{"lng":-3.1753599110220136,"lat":46.87826285354104},{"lng":-3.154316001408233,"lat":46.83987671580883},{"lng":-3.1543337683294794,"lat":46.839661233519706},{"lng":-3.1543454836356375,"lat":46.83951920128158},{"lng":-3.391960094422217,"lat":46.66704824781071},{"lng":-3.3742356120663715,"lat":46.57255142936849},{"lng":-3.205865753594395,"lat":46.460642563934556},{"lng":-3.0565958591596996,"lat":46.304335414811455},{"lng":-2.9980988334459937,"lat":46.17477086115893},{"lng":-2.701311666014277,"lat":46.01648950435652},{"lng":-2.630839250475475,"lat":46.01358530297147},{"lng":-2.221789133869038,"lat":45.81990425813234},{"lng":-2.1045909568092895,"lat":45.88306797867102},{"lng":-2.104649048434993,"lat":45.88216560708309},{"lng":-2.104777722840595,"lat":45.88016640572244},{"lng":-2.1044170504600572,"lat":45.88015484725065},{"lng":-2.104440481072345,"lat":45.87979088918858},{"lng":-2.103555956061882,"lat":45.87976251942571},{"lng":-2.1026358584165052,"lat":45.87973301539708},{"lng":-2.1001600883709557,"lat":45.87892924401374},{"lng":-2.098359655294786,"lat":45.87886656218504},{"lng":-2.095546507707553,"lat":45.87768734204121},{"lng":-2.0955589794656078,"lat":45.87749289146444},{"lng":-2.095569880131251,"lat":45.87732336781615},{"lng":-2.0934521639789523,"lat":45.8765311478113},{"lng":-2.093475517006425,"lat":45.876167166013005},{"lng":-2.091290631805805,"lat":45.87646199496407},{"lng":-2.0912762398237135,"lat":45.876686373426224},{"lng":-2.091267608513732,"lat":45.87682099196643},{"lng":-2.08975728443437,"lat":45.8778668571293},{"lng":-2.083268808674461,"lat":45.87765956535811},{"lng":-2.0819655778463755,"lat":45.87543463090015},{"lng":-2.0819975039952396,"lat":45.87493601913922},{"lng":-2.082151703803021,"lat":45.872527649056465},{"lng":-2.0791986126166933,"lat":45.873527666239305},{"lng":-2.078453895431892,"lat":45.87386865380485},{"lng":-2.0784108358629396,"lat":45.87454179087857},{"lng":-2.078384360046897,"lat":45.87495564067624},{"lng":-2.073759413209018,"lat":45.87953954419788},{"lng":-2.0690757152745505,"lat":45.87939041644023},{"lng":-2.07574604982662,"lat":45.876690167974786},{"lng":-2.0758368240530842,"lat":45.87522916661144},{"lng":-2.0761995136386417,"lat":45.87525071912852},{"lng":-2.0762071751385065,"lat":45.87513104583589},{"lng":-2.076292305070126,"lat":45.87379974072416},{"lng":-2.07866316105779,"lat":45.870597585274076},{"lng":-2.081211337126291,"lat":45.87031910711628},{"lng":-2.0855699159188816,"lat":45.875549712176465},{"lng":-2.085566094867062,"lat":45.87560953490021},{"lng":-2.0855466016838022,"lat":45.875913684515155},{"lng":-2.0880238652369485,"lat":45.87671728345996},{"lng":-2.088407580305727,"lat":45.87636983154534},{"lng":-2.08842197228779,"lat":45.87614545180504},{"lng":-2.0884309139370316,"lat":45.87600584869044},{"lng":-2.092489511065878,"lat":45.874676698202684},{"lng":-2.1123069600199926,"lat":45.88659274622658},{"lng":-2.1128330626093828,"lat":45.88660964988208},{"lng":-2.113028227196253,"lat":45.886615914494335},{"lng":-2.113459288394722,"lat":45.885535771492975},{"lng":-2.113817303495523,"lat":45.88554727483901},{"lng":-2.113934359576035,"lat":45.88373266006203},{"lng":-2.1137506193522597,"lat":45.88372675967921},{"lng":-2.1135763250789807,"lat":45.88372115634024},{"lng":-2.2641965249245857,"lat":45.67616943829033},{"lng":-2.1687728348319695,"lat":45.667551441875915},{"lng":-2.06078523534606,"lat":45.524412875068414},{"lng":-2.088119798853171,"lat":45.337914649952545},{"lng":-2.194141593242648,"lat":45.28475697267082},{"lng":-2.1770452374999536,"lat":45.19295311059604},{"lng":-2.31651902180775,"lat":45.18468452187018},{"lng":-2.2159169918312784,"lat":45.03531168411694},{"lng":-1.768269208627288,"lat":44.74260618891272},{"lng":-1.6615635817318264,"lat":44.55629279703378},{"lng":-1.661580456427771,"lat":44.55598664756118},{"lng":-1.6616453561204594,"lat":44.554807948069886},{"lng":-1.604813145236875,"lat":44.27227695662566},{"lng":-1.5131990050364266,"lat":44.125932973387506},{"lng":-1.5757102105758918,"lat":44.160292021158305},{"lng":-1.7083079636069272,"lat":44.3895795654082},{"lng":-1.713214853640494,"lat":44.45388067109968},{"lng":-2.1038430392511316,"lat":44.81490469429554},{"lng":-2.2047366329395857,"lat":44.80743002326925},{"lng":-2.2497785713521807,"lat":44.54701537013006},{"lng":-2.4314562805541016,"lat":43.62605269729407},{"lng":-2.278541316022171,"lat":43.81187097618087},{"lng":-2.1442657139131143,"lat":43.659154290459234},{"lng":-2.332430890272434,"lat":43.67973552782427},{"lng":-2.4425068982490643,"lat":43.5098754974191},{"lng":-2.4441289250571003,"lat":43.41877327186113},{"lng":-2.444283280034483,"lat":43.41629877314711},{"lng":-2.444468281011382,"lat":43.41631038248003},{"lng":-2.444656812097122,"lat":43.41631689159533},{"lng":-2.568284422877184,"lat":42.922442778786646},{"lng":-2.7842389067050135,"lat":42.28147132190636},{"lng":-2.8913673514129528,"lat":42.13812300052311},{"lng":-2.8913742758571743,"lat":42.13801692685678},{"lng":-2.8914428802244743,"lat":42.13696669448337},{"lng":-3.245860295884455,"lat":41.925453294142976},{"lng":-3.222661293636662,"lat":41.88726688188824},{"lng":-2.720274169166345,"lat":41.7161462732772},{"lng":-2.8630803567913574,"lat":41.51670782452759},{"lng":-2.8227230473308964,"lat":41.45827528271165},{"lng":-2.6381684352250545,"lat":41.48393095046947},{"lng":-2.0870732573654607,"lat":41.314573156452184},{"lng":-1.8818641919904735,"lat":41.31464104522852},{"lng":-1.8155809100215379,"lat":41.19060151227488},{"lng":-1.6838859726196915,"lat":41.1089392580519},{"lng":-1.3846377762561417,"lat":41.069812184361474},{"lng":-1.2636290213054906,"lat":41.11589053693834},{"lng":-1.2567887178332455,"lat":41.11588935330712},{"lng":-1.236729902538542,"lat":41.111091891362705},{"lng":-1.0597980948916472,"lat":41.01896810971623},{"lng":-1.0012554493102641,"lat":40.943371739782},{"lng":-0.3700346570030604,"lat":40.92492658924015},{"lng":-0.20781358860128307,"lat":40.891889033471045},{"lng":-0.20000432845023397,"lat":40.89498469536099},{"lng":-0.1958018308970111,"lat":40.89407826745551},{"lng":0.06510317704228896,"lat":40.87512889394205},{"lng":0.03687415766916047,"lat":41.008413251172314},{"lng":0.06260349147939337,"lat":41.09075193018099},{"lng":0.3004960110515924,"lat":41.06880636396592},{"lng":0.332334973999707,"lat":41.06470702938361},{"lng":0.3358061959363283,"lat":41.058345361442264},{"lng":1.0126839802289567,"lat":40.89411039188799},{"lng":1.1365622869229242,"lat":40.7241073951768},{"lng":1.1999589096981538,"lat":40.80781373115797},{"lng":1.5442239069962227,"lat":40.74782660766636},{"lng":1.5998700401131885,"lat":40.705922648313994},{"lng":1.60784907522239,"lat":40.696831647576744},{"lng":1.596592431067279,"lat":40.69488469714444},{"lng":1.5195789954566976,"lat":40.59186885864605},{"lng":1.8373213348769468,"lat":40.483305700148414},{"lng":1.8912231287345946,"lat":40.38749449745614},{"lng":2.3378255924116047,"lat":40.48467935030037},{"lng":2.5780692226375663,"lat":40.358273964142604},{"lng":2.7158915560985406,"lat":40.383041543981214},{"lng":2.845740712103378,"lat":40.36627771240414},{"lng":2.814071582302006,"lat":40.42236713192876},{"lng":2.978431469924118,"lat":40.462472394353526},{"lng":3.116331562759825,"lat":40.54123089189784},{"lng":3.353356781149131,"lat":40.549104287615016},{"lng":3.4295282470169184,"lat":40.483271754274675},{"lng":3.339826805111187,"lat":40.788963795421516},{"lng":3.3487554976779563,"lat":41.06583341327506},{"lng":3.3487032831015426,"lat":41.070630379089344},{"lng":3.3486912962485462,"lat":41.071731101291086},{"lng":3.3459409535641953,"lat":41.11295850002461},{"lng":3.3440435394768713,"lat":41.11098316460598},{"lng":3.3390577069002347,"lat":41.07559662146963},{"lng":3.3390632348178713,"lat":41.075084055870846},{"lng":3.339066202436811,"lat":41.07480890204887},{"lng":3.338311030699032,"lat":41.073627721950174},{"lng":3.3367695951113205,"lat":41.07440016095266},{"lng":3.3352127977314296,"lat":41.07635956258804},{"lng":3.335207424983423,"lat":41.076861313015705},{"lng":3.33520019019997,"lat":41.07753572237069},{"lng":3.33168053594639,"lat":41.08379860411042},{"lng":3.3286443126372944,"lat":41.080639159030056},{"lng":3.328652303872616,"lat":41.07988926542578},{"lng":3.3282688215582255,"lat":41.079849043750905},{"lng":3.318902337310817,"lat":41.02240697474376},{"lng":3.232123864289349,"lat":41.06511893103684},{"lng":3.2750675215442584,"lat":41.106231424866124},{"lng":3.27506422418989,"lat":41.10656039040139},{"lng":3.27506364230382,"lat":41.10661971187992},{"lng":3.397713994830525,"lat":41.377846459090954},{"lng":3.3381629212988173,"lat":41.33518895114572},{"lng":3.2406514046014934,"lat":41.45190873136754},{"lng":3.28244162789818,"lat":41.510731389333245},{"lng":3.415746585858841,"lat":41.404560635162575},{"lng":3.6132011853541144,"lat":41.600507048515205},{"lng":3.6136497613231597,"lat":41.60051083414497},{"lng":3.614724601869966,"lat":41.60051988484512},{"lng":3.7473452618158376,"lat":41.67612123247629},{"lng":3.9982790701106694,"lat":41.70127441814092},{"lng":4.162813581741517,"lat":41.8451357285405},{"lng":4.61036005858125,"lat":42.07122018205192},{"lng":4.782654796763893,"lat":42.092577539352895},{"lng":4.782736105643636,"lat":42.092578892313504},{"lng":4.783413227063619,"lat":42.092590219759025},{"lng":4.805646589383173,"lat":42.01899980874764},{"lng":4.839911726287767,"lat":41.989358937126596},{"lng":4.96181580993354,"lat":41.96319484828959},{"lng":4.962052947902038,"lat":41.96319911735577},{"lng":4.963331817100141,"lat":41.96322213569427},{"lng":5.391961391259258,"lat":41.95607470069106},{"lng":5.48948336250956,"lat":41.826148580612426},{"lng":5.865318413807984,"lat":41.83715257424759},{"lng":5.7927233166890915,"lat":41.86337670550607},{"lng":5.93961374322231,"lat":41.94150842685187},{"lng":6.0744871750766265,"lat":41.80509002345877},{"lng":6.4704010197580715,"lat":41.83650838801548},{"lng":6.657791434215369,"lat":41.6555405284598},{"lng":6.8619414669483945,"lat":41.5904403606619},{"lng":6.949650123640396,"lat":41.62054645301462},{"lng":6.951920546092879,"lat":41.62061938708857},{"lng":6.951959493666976,"lat":41.6202295730803},{"lng":7.144643888165831,"lat":41.53442532425495},{"lng":7.224452840215804,"lat":41.45581939454137},{"lng":7.33661075895543,"lat":41.474153917825504},{"lng":7.2724281632732755,"lat":41.525480344240435},{"lng":7.624852657946121,"lat":41.501702889320036},{"lng":7.7659924208562074,"lat":41.56715984539755},{"lng":8.284343473197993,"lat":41.681046733262384},{"lng":8.306887950601435,"lat":41.72916186654307},{"lng":8.19690017594877,"lat":41.806798431429186},{"lng":8.368806311219629,"lat":41.90768953337142},{"lng":8.384171361950905,"lat":41.99495896223882},{"lng":8.593715284563189,"lat":42.03153296665065},{"lng":8.650812622135106,"lat":42.105791982435626},{"lng":8.65078145243811,"lat":42.10620046130437},{"lng":8.650753929227164,"lat":42.1065611914587},{"lng":8.683263205528306,"lat":42.19282674376952},{"lng":8.873802554625883,"lat":42.2412796060223},{"lng":8.90886056948537,"lat":42.32484447887072},{"lng":9.044659316563468,"lat":42.411855276479635},{"lng":9.405167411271776,"lat":42.552991241422205},{"lng":9.374514991599142,"lat":42.655226681509546},{"lng":9.570411494168951,"lat":42.83801405296255},{"lng":9.639582405141681,"lat":42.995606840242736},{"lng":9.593670527662681,"lat":43.113076818278735},{"lng":9.52966273055506,"lat":43.11339656388633},{"lng":9.294818033220935,"lat":43.032929270372016},{"lng":9.053501249917758,"lat":43.04161209678997},{"lng":8.988557508467522,"lat":43.081436882379975},{"lng":8.673985691660647,"lat":43.16408254326801},{"lng":8.659882228111258,"lat":43.21230544410983},{"lng":8.511652377436548,"lat":43.32445023968196},{"lng":8.512442714488998,"lat":43.32606115462004},{"lng":8.521053891225193,"lat":43.34361876323841},{"lng":8.566165655965818,"lat":43.42897762789905},{"lng":8.450270690337987,"lat":43.54737133417161},{"lng":8.54478019862691,"lat":43.61264039239201},{"lng":8.552437799872706,"lat":43.7185967135835},{"lng":8.553462714594957,"lat":43.719258633891755},{"lng":8.569387830665761,"lat":43.7295382211494},{"lng":8.709783943182202,"lat":43.777243159364765},{"lng":8.611547454634007,"lat":43.910469409154885},{"lng":8.625450904545971,"lat":43.951739592456995},{"lng":8.339493664820225,"lat":44.02557107930812},{"lng":8.228457059927933,"lat":44.206033847298784},{"lng":8.143556585395316,"lat":44.21604362371278},{"lng":8.07554190143398,"lat":44.31477061746328},{"lng":8.076998420448348,"lat":44.31595365510782},{"lng":8.086952357472825,"lat":44.3240247229856},{"lng":8.25887148819919,"lat":44.383322008042214},{"lng":8.49632949404895,"lat":44.42223752926633},{"lng":8.560678877674121,"lat":44.48079073358667},{"lng":8.641307299872295,"lat":44.4763047624378},{"lng":8.727279259408704,"lat":44.538140924808026},{"lng":8.77447359438321,"lat":44.73813514505981},{"lng":8.599143525116773,"lat":44.83219005952682},{"lng":8.510945424657564,"lat":44.91334240972519},{"lng":8.522473945379375,"lat":45.04366769763397},{"lng":8.247897601880254,"lat":45.212707216803494},{"lng":8.248360065530107,"lat":45.22208392097487},{"lng":8.250408168712596,"lat":45.26367277537575},{"lng":8.493982107465968,"lat":45.36423722066612},{"lng":8.496100056372683,"lat":45.473590526015165},{"lng":8.379605573529972,"lat":45.60278832473578},{"lng":8.193792535823178,"lat":45.693399173996795},{"lng":8.196446906098913,"lat":45.77833841390654},{"lng":8.257732950524257,"lat":45.89382253190462},{"lng":8.00082107753127,"lat":46.0992487411674},{"lng":7.796328391489567,"lat":46.091124415587814},{"lng":7.461000737464474,"lat":45.95641519395431},{"lng":7.524987955201539,"lat":45.77746908223233},{"lng":7.37624534652457,"lat":45.684612948273596},{"lng":7.095216623597906,"lat":45.63519157384068},{"lng":7.093261176073469,"lat":45.64057120771249},{"lng":7.095238987419066,"lat":45.64188586298197},{"lng":7.145175266522386,"lat":45.76089932694994},{"lng":7.27000600433081,"lat":45.84708660506697},{"lng":7.3194662812351226,"lat":45.97314056415765},{"lng":7.252649506723742,"lat":46.00804214711587},{"lng":7.208537810170299,"lat":46.016921853681666},{"lng":7.225477677353354,"lat":46.04007595614425},{"lng":7.245718041100986,"lat":46.10465797709433},{"lng":7.270019853219225,"lat":46.14553707574499},{"lng":7.315181912312255,"lat":46.189307795762886},{"lng":7.291635310724246,"lat":46.2042565327885},{"lng":7.257573853339352,"lat":46.225822801432585},{"lng":7.671809874348469,"lat":46.49816782756812},{"lng":7.636052335455446,"lat":46.696508176132},{"lng":7.959076241347816,"lat":46.887535522187626},{"lng":8.230283445122694,"lat":47.09686167913402},{"lng":8.247260979730498,"lat":47.18161501945427},{"lng":8.375374175635415,"lat":47.28145567211046},{"lng":8.162240171159283,"lat":47.26231220095198},{"lng":8.232398135467491,"lat":47.33831914366568},{"lng":8.22867899127391,"lat":47.3687829633796},{"lng":8.235220670816574,"lat":47.369508703000875},{"lng":8.328828119928204,"lat":47.46279716985127},{"lng":8.452135945522059,"lat":47.4617015271101},{"lng":8.463242172128844,"lat":47.466950365373066},{"lng":8.486869733465,"lat":47.46138681671598},{"lng":8.522971807098344,"lat":47.39620693009871},{"lng":8.60822839590395,"lat":47.38059874712327},{"lng":9.029112057908549,"lat":47.584702579595685},{"lng":8.934549675572327,"lat":47.84374105075722},{"lng":9.005423825251825,"lat":48.12063582523992},{"lng":8.950656611642898,"lat":48.16339982022228},{"lng":8.951920642746273,"lat":48.26804188892283},{"lng":8.951399040075785,"lat":48.270252969145794},{"lng":8.962956558119942,"lat":48.27908414803294},{"lng":9.177665146293492,"lat":48.826769979492745},{"lng":9.354728479587749,"lat":49.07974359336563},{"lng":9.484839697680968,"lat":49.13844692499606},{"lng":9.595433079955995,"lat":49.32442620816927},{"lng":9.640894286676115,"lat":49.351163118145564},{"lng":9.471318663292294,"lat":49.37252011988805},{"lng":9.272302165215933,"lat":49.44495935941343},{"lng":9.174989478987726,"lat":49.414762020342486},{"lng":9.089874637628043,"lat":49.43916271649939},{"lng":8.947012181620323,"lat":49.417040573639085},{"lng":8.901958256354732,"lat":49.42502906584795},{"lng":8.889754844776206,"lat":49.44804716356137},{"lng":8.768552166595612,"lat":49.47165632202379},{"lng":8.710566909677823,"lat":49.55642996935847},{"lng":8.48648718216836,"lat":49.49231321862699},{"lng":8.18579788677124,"lat":49.46571372385892},{"lng":8.147168565571633,"lat":49.5567283827009},{"lng":8.00909268495505,"lat":49.593755689971665},{"lng":7.761762477677081,"lat":49.57977223081199},{"lng":7.587702297167112,"lat":49.698571780332344},{"lng":7.535711106814318,"lat":49.81464344935214},{"lng":7.447146553906322,"lat":49.85207753645038},{"lng":7.187495626818674,"lat":49.905092672601334},{"lng":7.009636874666995,"lat":49.88316207100267},{"lng":6.960457474167271,"lat":49.83968016703628},{"lng":6.835180293972002,"lat":49.83039127002151},{"lng":6.728708740445114,"lat":49.88428530775641},{"lng":6.7214847800926805,"lat":49.88219262324821},{"lng":6.685269005921839,"lat":49.886356619020475},{"lng":6.64781887683705,"lat":49.934362022824466},{"lng":6.468272752072011,"lat":49.93436058708948},{"lng":6.371525911251609,"lat":49.88423886657447},{"lng":6.222427188301651,"lat":49.87981086461339},{"lng":6.2062038362252565,"lat":49.86789083251984},{"lng":6.200481103133342,"lat":49.86976036270609},{"lng":6.180112414111733,"lat":49.95051502872174},{"lng":6.162657597155544,"lat":49.95455751931875},{"lng":6.11366197567196,"lat":50.00377484629445},{"lng":6.102779561842766,"lat":50.01034777969617},{"lng":6.081429774119755,"lat":50.01593569348421},{"lng":5.944776721314241,"lat":50.10161592430179},{"lng":5.766757969890335,"lat":50.123079739466924},{"lng":5.60148754695058,"lat":50.219192809256754},{"lng":5.436813615418089,"lat":50.2092678796564},{"lng":5.463633209755898,"lat":50.33426846441506},{"lng":5.383993528362822,"lat":50.398339401699445},{"lng":5.437935918471766,"lat":50.63884685113429},{"lng":5.374380363215437,"lat":50.654521656304844},{"lng":5.21059417646299,"lat":50.53178510881518},{"lng":5.2218950245629685,"lat":50.46469513873686},{"lng":5.026660824714668,"lat":50.38903545294232},{"lng":4.697595680693496,"lat":50.39688779198437},{"lng":4.674399471498816,"lat":50.39082030825255},{"lng":4.631376425588144,"lat":50.38614367730405},{"lng":4.602063022736729,"lat":50.411527621017946},{"lng":4.578206780176231,"lat":50.4100761061807},{"lng":4.56747914804086,"lat":50.41279857004836},{"lng":4.562063728377126,"lat":50.41417068801974},{"lng":4.562132798253259,"lat":50.414235725810755},{"lng":4.662041821320088,"lat":50.53649525575348},{"lng":4.563554830820038,"lat":50.69452038798729},{"lng":4.645843955853451,"lat":50.74450161144487},{"lng":4.3611362776642295,"lat":50.845121750581825},{"lng":4.240807611752501,"lat":50.8252505369051},{"lng":3.9751464222709956,"lat":50.84819326569322},{"lng":3.9830748720848135,"lat":50.89578202852436},{"lng":3.9018189245557835,"lat":51.02218689198506},{"lng":3.6247507509556556,"lat":51.0140406004652},{"lng":3.5167989180666837,"lat":51.05541202689947},{"lng":3.4803006963989276,"lat":51.248817545334695},{"lng":3.345069443405748,"lat":51.363160240550734},{"lng":3.0883043996636843,"lat":51.28582335205366},{"lng":2.9228012610895178,"lat":51.287783013117945},{"lng":2.8371008483844093,"lat":51.38677881908424},{"lng":2.7470526217788915,"lat":51.387648898745624},{"lng":2.729169750035595,"lat":51.54727288572859},{"lng":2.6294572686859965,"lat":51.71053648706964},{"lng":2.0728576813868074,"lat":51.61550445802927},{"lng":2.072638000000296,"lat":51.615505000000006}]}';
