package fr.unice.iut.shapes.resources;

import fr.unice.iut.shapes.providers.PolygonCalculator;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

public class GeoPolygon {

    // Les sommets ordonnes du polygone
    private List<GeoPoint> vertices;

    public GeoPolygon() {
        this.vertices = new ArrayList<GeoPoint>();
    }

    public List<GeoPoint> getVertices() {
        return vertices;
    }

    public void setVertices(List<GeoPoint> vertices) {
        this.vertices = vertices;
    }

    /**
     * Ajout d'un sommet au polygone
     *
     * @param point - le {@link GeoPoint a ajouter}
     */
    public void addVertex(GeoPoint point) {
        if (this.vertices == null) {
            this.vertices = new ArrayList<GeoPoint>();
        }
        this.vertices.add(point);
    }

    /**
     * Effectue la rotation du polygone par rapport au premier sommet defini.
     * Transformation dans un repere classique avant de reporter le resultat dans la projection de Mercator.
     *
     * @param angle - l'angle de rotation du polygone, en degres
     */
    public void rotate(Double angle) {
        throw new UnsupportedOperationException("Not Yet Implemented");
    }
}
