package fr.unice.iut.library;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.Random;

@XmlRootElement
public class Book {

    private String isbn;
    private String title;
    private int hidden;

    public Book(String isbn, String title) {
        this.isbn = isbn;
        this.title = title;
        this.hidden = new Random().nextInt();
    }

    @XmlElement(name="ISBN")
    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    @XmlElement(name="titre")
    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @XmlTransient
    public int getHidden() {
        return hidden;
    }

    public void setHidden(int hidden) {
        this.hidden = hidden;
    }
}
