package fr.unice.iut.library;

import fr.unice.iut.library.exceptions.BookAlreadyExistException;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Library {

    private static Set<Book> allBooks = new HashSet<Book>();

    static {
        allBooks.add(new Book("42", "Le guide du voyageur galactique"));
        allBooks.add(new Book("1313", "L'imparfait du futur"));
    }

    public static Book retrieveBookByISBN(String isbn) {
        for (Book b : allBooks) {
            if (b.getIsbn().equals(isbn)) {
                return b;
            }
        }
        return null;
    }

    public static List<Book> getAllBooks() {
        return new ArrayList<Book>(allBooks);
    }

    public static void createBook(Book b) throws BookAlreadyExistException {
        if (retrieveBookByISBN(b.getIsbn()) != null) {
            throw new BookAlreadyExistException();
        } else {
            allBooks.add(b);
        }
    }

    public static void deleteBook(Book b) {
        allBooks.remove(b);
    }

}
