package TennisGameV0;





import TennisGame.Ball;
import TennisGame.Racquet;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

/**
 * Created by http://www.edu4java.com/en/game/game3.html
 * Modified by blay on 05/03/2017.
 */

public class Game extends JPanel {

    //----- Manage the ball
    private final int ballSize = 30;
    private Ball ball = new Ball(ballSize,1,1);
    private BallUI ballUI = new BallUI(this,ball);

    //----- Manage the racquet

    private final int RacquetWidth = 60;
    private final int RacquetHeight = 10;
    private final int RacquetY = 300;

    private Racquet racquet = new Racquet(RacquetWidth,RacquetHeight,RacquetY);
    private RaquetUI racquetUI = new RaquetUI(this,racquet);



    //----- Manage the game :
    public Game() {
        addKeyListener(new KeyListener() {
            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                racquetUI.keyReleased(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                racquetUI.keyPressed(e);
            }
        });
        setFocusable(true);
    }


    //Manage userName
    private String userName = " John Doe" ;

    private  String askPlayerName(){
        String s = (String)JOptionPane.showInputDialog(
                this,
                " User Name ? ",
                " Ask User name ",
                JOptionPane.PLAIN_MESSAGE,
                null,
                null,
                userName);
        return s;
    }

    private  String playerTurn(){
        return askPlayerName();
    }

    private void setUserName(String name){
        userName = name;
    }




    // -----------------

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D) g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //Draw Ball and Racquet
        ballUI.paint(g2d);
        racquetUI.paint(g2d);

        g2d.setColor(Color.GRAY);
        g2d.setFont(new Font("Verdana", Font.BOLD, 30));
        g2d.drawString("Jeux : " + userName, 10, 30);
    }

    private void play() {
        racquet.moveIn(getWidth());
        ball.moveIn(getWidth(), getHeight());
    }


    //For next Step
    private void gameOver() {
        JOptionPane.showMessageDialog(this, "Game Over", "Game Over", JOptionPane.YES_NO_OPTION);
        System.exit(ABORT);
    }

    public static void main(String[] args) throws InterruptedException {
        JFrame frame = new JFrame("Mini Tennis");
        Game game = new Game();
        frame.add(game);
        frame.setSize(300, 400);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        String playerName = game.playerTurn();
        game.setUserName(playerName);

        while (true) {
            game.play();
            game.repaint();
            Thread.sleep(10);
        }

    }


}