package diceGameV0;

import diceGameV1.UnexpectedValue;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.util.Random;

import static org.junit.Assert.*;
import static org.mockito.Mockito.*;

/**
 * Created by blay on 18/10/2016.
 * Modified by blay on 18/10/2016.
 */
public class GameTest_Model2016 {


    //Step0
    Game game;

    @Before
    public void setUp() throws Exception {
        game = new Game(new Random());
    }

    @After
    public void tearDown() throws Exception {
    }


    //Step 1
    @Test
    public void testGame() {
        game = new Game(new Random());
        assertEquals(0, game.getTurn());
        assertEquals(0, game.getResult());
    }


    //Step 2 -----------------------------------------------------------------
    @Test
    public void testGameTurnMustIncrementTurn() throws Exception {
        this.game = new Game(new Random() );
        game.gameTurn();
        assertEquals("Turn value is 1", 1, game.getTurn());
        game.gameTurn();
        assertEquals("Turn value is 2", 2, game.getTurn());
    }

    //Step4 et Step5 ---------------------------------------------------------
    @Test
    public void testGameTurnWhenWinning() throws Exception {
        Random mockRandom = mock(Random.class);
        when(mockRandom.nextInt(6)).thenReturn(Game.WIN_NUMBER);
        when(mockRandom.nextInt(6)).thenReturn(Game.WIN_NUMBER);
        game = new Game(mockRandom);
        game.gameTurn();
        assertEquals("Result value is " + game.GAIN, game.GAIN,game.getResult());
        game.gameTurn();
        assertEquals(game.GAIN*2,game.getResult());
    }


    @Test
    public void testGameTurnWhenLosing() throws Exception {
        Random mockRandom = mock(Random.class);
        when(mockRandom.nextInt(6)).thenReturn(1);
        game = new Game(mockRandom);
        game.gameTurn();
        assertEquals(0,game.getResult());
        game.gameTurn();
        assertEquals(0,game.getResult());
    }

    //Step6 ---------------------------------------------------------
    @Test(expected = UnexpectedValue.class)
    public void testGameTurnWhenRandomFails() throws Exception {
        Random mockRandom = mock(Random.class);
        when(mockRandom.nextInt(6)).thenReturn(0);
        game = new Game(mockRandom);
        game.gameTurn();
    }



    //Step Intégration 1:
    @Test
    public void testGameRandomIsCalled()throws Exception {
        Random mockRandom = mock(Random.class);
        when(mockRandom.nextInt(6)).thenReturn(0);
        //expect
        game = new Game(mockRandom);
        game.gameTurn();
        verify(mockRandom).nextInt(6);
    }

    //Step Intégration 2:
    @Test
    public void testGameRandomIsCalledTwoTimes() throws Exception {
        Random mockRandom = mock(Random.class);
        //expect
        game = new Game(mockRandom);
        game.gameTurn();
        game.gameTurn();
        verify(mockRandom, times(2)).nextInt(6);
    }


}
