package diceGameV1;

import java.util.Random;

public class Game {

	private static int WIN_NUMBER = 5;
	private static int GAIN = 3;
	
	private int result;
	private int turn;
	private Random diceOne;
	
	public Game(Random diceOne) {
		this.result = 0;
		this.turn = 0;
		this.diceOne = diceOne;
	}
	
	public int getTurn() {
		return this.turn;
	}
	
	protected void gameTurn() throws UnexpectedValue {
		int diceResult = this.diceOne.nextInt(6)+1;
		if (diceResult > 6 || diceResult < 1) {
			throw new UnexpectedValue("Dice result must be between boundaries [1,6]");
		}
		if (diceResult == WIN_NUMBER) {
			this.result += GAIN;
		}
		this.turn++;
	}
	
	public String toString() {
		return "Tour : "+this.turn+" |�Resultat : "+this.result+"\n";
	}
	
	public static void main(String[] args) throws Exception {
		Game game = new Game(new Random());
		System.out.println(game);
		for (int i = 0; i < 100; i++) {
			game.gameTurn();
			System.out.println(game);
		}
		
	}
}
