package openClosedPrinciples.core;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Mireille Blay-Fornarino
 *
 * 6 oct. 2018
 */
public class CarRentalService {

	private ArrayList<Car> cars;
	private ArrayList<CarRental> carRentals = new ArrayList<>();

	public CarRentalService(ArrayList<Car> cars) {
		super();
		this.cars = cars;
	}

	public List<Car> getAvailableCars(LocalDate d, int duration) {
		ArrayList<Car> availableCars = new ArrayList<>();
		LocalDate[] dates = DateTools.getDays(d, duration);
		for (Car c : cars) {
			if (isAvailable(c, dates)) {
				availableCars.add(c);
			}
		}
		return availableCars;
	}
	

	private boolean isAvailable(Car c, LocalDate[] dates) {
		for (CarRental carRental : carRentals) {
			if (c.getNumberPlate().equals(carRental.getCarNumber()) &&
				(carRental.includeADate(dates)) ) {
				return false;	
			}	
		}
		return true;
	}
	
	public CarRental book(Car c, LocalDate d, int duration) throws NotPossibleCarRentalException  {
		CarRental carRental = null;
		if (cars == null || !(cars.contains(c)) )
			throw new NotPossibleCarRentalException("Not known car");
		LocalDate[] dates = DateTools.getDays(d, duration);
		if (isAvailable(c, dates)) {
			carRental = new CarRental(c, d, duration);
			carRentals.add(carRental);
		}
		return carRental;
	}
	
	

}
