package openClosedPrinciples.core;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Mireille Blay-Fornarino
 *
 * 6 oct. 2018
 */
public class FlightService {

	private ArrayList<Flight> flights = new ArrayList<>();
	
	public FlightService(ArrayList<Flight> flights) {
		this.flights = flights;
	}
	
	public List<Flight> getFlights(LocalDate d) {
		Stream<Flight> parallelStream = flights.parallelStream(); 
		Stream<Flight> results = parallelStream.filter(f -> (f.getDepartDate().equals(d)) ) ;
		return results.collect(Collectors.toCollection(ArrayList::new));
	}

	public List<Flight> getFlights(LocalDate d, String from, String to) {
		Stream<Flight> parallelStream = flights.parallelStream(); 
		Stream<Flight> results = parallelStream.filter(f -> 
		             f.match(d, from, to))  ;
		return results.collect(Collectors.toCollection(ArrayList::new));
	}
	
	
}
