package openClosedPrinciples.core;

import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Random;

/**
 * @author Mireille Blay-Fornarino
 *
 * 6 oct. 2018
 */
public class Flight {

	private double price = -1;
	private LocalDate departDate;
	private String departAirport;
	private String arrivalAirport;
	private LocalTime departTime;
	
	public LocalTime getDepartTime() {
		return departTime;
	}
	public void setDepartTime(LocalTime departTime) {
		this.departTime = departTime;
	}
	public Flight(String departAirport) {
		this(-1, LocalDate.now(), LocalTime.now(), departAirport, "Paris");
	}
	public Flight(double price, LocalDate departDate, LocalTime departTime, String departAirport, String arrivalAirport) {
		super();
		this.price = price;
		this.departDate = departDate;
		this.departAirport = departAirport;
		this.arrivalAirport = arrivalAirport;
		this.departTime= departTime;
	}
	public LocalDate getDepartDate() {
		return departDate;
	}
	public void setDepartDate(LocalDate departDate) {
		this.departDate = departDate;
	}
	

	public String getDepartAirport() {
		return departAirport;
	}
	public void setDepartAirport(String departAirport) {
		this.departAirport = departAirport;
	}

	public String getArrivalAirport() {
		return arrivalAirport;
	}
	public void setArrivalAirport(String arrivalAirport) {
		this.arrivalAirport = arrivalAirport;
	}

	public void setPrice(double price) {
		this.price = price;
	}

	public double getPrice() {
		if (price == -1) {
		double start = 10;
		double end = 1000;
		double random = new Random().nextDouble();
		price = start + (random * (end - start));
		}
		return price;
	}

	public boolean match(LocalDate d, String from, String to) {
			return getDepartDate().equals(d) && getDepartAirport().equals(from) && getArrivalAirport().equals(to);
	
	}
}
