package grapheSimple;

import grapheX.Arc;
import grapheX.Sommet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/**
 * Cette classe d�finit un parcours simple de graphes
 * contenant des arcs inverses et plusieurs arcs entre deux sommets donn�s.
 * @author blay
 *
 */
public class ParcoursSimple<T extends Sommet> {

	GrapheSimple<T> graphe;


	public ParcoursSimple(GrapheSimple<T> graphe) {
		super();
		this.graphe = graphe;
	}

	
	
	/**
	 * @param origine
	 * @return une liste de chemin
	 * Cette m�thode renvoie les chemins les plus longs possibles � partir du point d'orgine
	 */
	public List<Chemin<T>> chemins(T origine){
		HashMap<T,ArrayList<Arc<T>>> dejaVu = new HashMap<>();
		return chemins(origine,dejaVu);
	}
	
	/**
	 * @param origine
	 * @param destination
	 * @return une liste de chemins entre deux Ts
	 * Cette m�thode renvoie tous les chemins entre deux Sommets donnes
	 */
	//Pbme avec la comparaison des chemins... qui considere comme �gal deux objets diff�rents... cela doit venir de l'h�ritage...

	public List<Chemin<T>> chemins(T origine, T destination){
		List<Chemin<T>> chemins = chemins(origine);
		List<Chemin<T>> cheminsEntreDeuxSommets = new ArrayList<> ();
		for(Chemin<T> c : chemins) {
			if (c.atteint(destination)){
				Chemin<T> raccourcis = c.extraireChemin(origine, destination);
				if (! cheminsEntreDeuxSommets.contains(raccourcis)) {
					cheminsEntreDeuxSommets.add(raccourcis);
				}
			}
		}
		return cheminsEntreDeuxSommets;
	}
	
	

	private List<Chemin<T>> chemins(T origine, HashMap<T,ArrayList<Arc<T>>> dejaVu){

		List<Chemin<T>> chemins = new ArrayList<>();

		if  (dejaVu.containsKey(origine)){
			chemins.add(new Chemin<>(dejaVu.get(origine)));
			return chemins;
		}

		
		dejaVu.put(origine, new ArrayList<Arc<T>>());


		Collection<Arc<T>> voisins = graphe.voisins(origine);	
		HashMap<T,ArrayList<Arc<T>>> dejavVuLocal ;

		for (Arc<T> a : voisins) {
			T destination = a.destination();
			dejavVuLocal= new HashMap<>(dejaVu);

			if (nouvelleDestinationOuNouvelArcSansRetour(origine,dejavVuLocal,destination,a)) { 
				dejavVuLocal.get(origine).add(a);
				List<Chemin<T>> cheminsLocaux = chemins(destination,dejavVuLocal);
				if (cheminsLocaux.isEmpty()) {
					Chemin<T> chemin = new Chemin<>();
					chemin.add(a);
					chemins.add(chemin);
					}
				else {
					for (Chemin<T> c : cheminsLocaux) {
						c.add(0,a);
						chemins.add(c);
					}
				}
			}
		}
		return chemins;
	}
	
	
	//todo : tenir compte de Origine
	private boolean nouvelleDestinationOuNouvelArcSansRetour(
		T origine, HashMap<T, ArrayList<Arc<T>>> dejaVu, T destination,
		Arc<T> a) {

		if (! dejaVu.containsKey(destination) )
			return true;

		return ( (! dejaVu.get(destination).contains(a)) && (! dejaVu.containsKey(a.destination()) ) );
	}
	
	
	public Chemin<T> cheminLePlusCourt(T origine, T destination){
		List<Chemin<T>> chemins = this.chemins(origine, destination);
		Chemin<T> cheminLePlusCourt = null;
		int distanceLaPlusCourte = Integer.MAX_VALUE;
		for(Chemin<T> c : chemins) {
			if (distanceLaPlusCourte > c.distance()) {
				distanceLaPlusCourte = c.distance();
				cheminLePlusCourt = c;
			}
		}
		return cheminLePlusCourt;
	}
	
	public Set<T> voisinsAuRang(T origine, int rang){
		List<Chemin<T>> chemins = chemins(origine);
		Set<T> TsVoisinsDejaVu = new TreeSet<>();
		Set<T> TsDeBonRang = new TreeSet<>();
		for (Chemin<T> c : chemins) {
			List<T> sommets = c.sommets();
			int i = 0;
			for (i = 0; (i <sommets.size() && i < rang); i++)
				TsVoisinsDejaVu.add(sommets.get(i));
			if ( (i == rang) && (i < sommets.size()) )
				TsDeBonRang.add(sommets.get(i));
			}
		TsDeBonRang.removeAll(TsVoisinsDejaVu);
		return TsDeBonRang;
	}
}
	
	
