package grapheSimple;

import grapheX.Arc;
import grapheX.Graphe;
import grapheX.Identifiable;
import grapheX.Sommet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/**
 * Cette classe a ete necessaire pour gérer les graphes ayant plusieurs arétes entre deux sommets données
 * et ayant des arcs dans les deux sens entre deux sommets.
 * Ces fonctionnalités n'étaient pas prises en charge par les classes initiales.
 * Elle permet egalement de simplifier la comprehension des codes données.
 * @author blay
 *
 */
public class GrapheSimple<T extends Sommet> extends Graphe<T> {
    HashMap<String,T> mesSommets = new HashMap<>();

    HashMap<T,HashMap<T,ArrayList<Arc<T>>>> aretes;


    public  GrapheSimple() {
        aretes = new HashMap<>();
    }


    public T getSommet(String ident){
        return mesSommets.get(ident);
    }

    @Override
    public int taille() {
        return mesSommets.size();
    }


    @Override

    public Graphe<T> copie() {
        //@TODO
        return null;
    }

    //n'ajoute le sommet que s'il n'est pas deja dans le graphe.
    @Override
    public void ajouterSommet(T s) {
        if (existeSommet(s))
            return;
        mesSommets.put(s.identifiant(), s);
        aretes.put(s,new HashMap<T,ArrayList<Arc<T>>>());
    }

    @Override
    public boolean existeArc(Sommet s, Sommet t) {
        return aretes.get(s).containsKey(t);
    }


    //A revoir avec la nouvelle version
    //@todo
    private boolean existeSommet(T s) {
        return aretes.containsKey(s);
    }


    public List<Arc<T>> arcs(T s, T t) {
        return aretes.get(s).get(t);
    }

    @Override
    public void ajouterArc(T s, T t) {
        this.ajouterArc(s,t,0);
    }


    @Override
    public void ajouterArc(Arc<T> arc) {
        HashMap<T, ArrayList<Arc<T>>> s = aretes.get(arc.origine());
        if (s == null){
            ajouterSommet(arc.origine());
            s=aretes.get(arc.origine());
        }
        if (aretes.get(arc.destination()) == null)
            ajouterSommet(arc.destination());
        if  (s.get(arc.destination()) == null)
            s.put(arc.destination(), new ArrayList<>());
        s.get(arc.destination()).add(arc);

    }
    @Override
    public void ajouterArc(T s, T t, int val) {
        Arc<T> a = new Arc<>(s,t,val);
        this.ajouterArc(a);
    }

    //Remarque : gestion horrible des exceptions mais on s'adapte à cause de l'héritage qui nous interdit de lever une exception.
    @Override
    public int valeurArc(T s, T t)  {
        if (!existeArc(s,t)) throw new Error("Arc inexistant");
        return aretes.get(s).get(t).get(0).valeur();
    }

    //RETIRE TOUS LES ARCS VERS T
    @Override
    public void enleverArc(Sommet s, Sommet t) {
        if (!existeArc(s,t)) return ;
        aretes.get(s).remove(t);
    }

    @Override
    public Collection<T> sommets() {
        return mesSommets.values();
    }

    @Override
    public Collection<Arc<T>> voisins(Sommet s) {
        ArrayList<Arc<T>> voisins = new ArrayList<>();
        HashMap<T, ArrayList<Arc<T>>> arcs = aretes.get(s);
        if ( arcs != null )
            for (ArrayList<Arc<T>> av : arcs.values())
                voisins.addAll(av);
        return voisins ;
    }

    @Override
    public String toString() {
        return "Sommets=" + mesSommets + ";\n arcs="
                + toStringArretes(aretes) + "]";
    }

    private String toStringArretes(
            HashMap<T, HashMap<T, ArrayList<Arc<T>>>> aretes2) {
        StringBuilder bld = new StringBuilder();
        for ( HashMap<T, ArrayList<Arc<T>>> x : aretes2.values()){
            for ( ArrayList<Arc<T>> edges : x.values())
                for (Arc<T> a : edges)
                    bld.append( "\t").append(a).append("\n" );
        }
        return bld.toString();
    }






}
