package reseauSocialTestV2;

import static org.junit.Assert.*;

import java.util.Collection;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import reseauSocial.core.MemberInterface;
import reseauSocial.core.SocialNetworkInterface;
import reseauSocial.implementation2019.Member;
import reseauSocial.implementation2019.SocialNetWorkImpl;




public class FirstTests {

	
    //TODO : reference to be modified according to your implementation
	//Member refers to your implementation of MemberInterface
	//SocialNetWorkImpl refers to your implementation of SocialNetworkInterface
    SocialNetworkInterface<Member> iutRS;

    @BeforeEach
    public void setUp() throws Exception {
        iutRS = new SocialNetWorkImpl("IUT");
    }
    
    /*
     * utility functions
     */

    private Member addMember(String nom, String location, SocialNetworkInterface<Member> nw  ) {
    	Member m = new Member(nom);
    	m.setLocation(location);
        nw.addMember(m);
        return m;
	}
   

    @Test
    public void testInit() {
        assertTrue(iutRS != null);
    }

    
    
    /*
        Serie of simple tests
     */


    @Test
    public void testAddAndGetMemberSimple() {
    	String location = "Nice";
        MemberInterface m_geek01 = addMember("geek01", location, iutRS);
        assertEquals("geek01", m_geek01.getName());
        assertEquals(location, m_geek01.getLocation());
    }
    @Test
    public void testAddAndGetTwoMembers() {
        MemberInterface m_geek01 = addMember("geek01", "Nice", iutRS);
        MemberInterface m_geek02 = addMember("ivana","Toulon", iutRS);
        assertEquals("geek01", m_geek01.getName());
        assertEquals("ivana", m_geek02.getName());
    }

    @Test
    public void testGetMembers() {
    	 MemberInterface m_geek01 = addMember("geek01", "Nice", iutRS);
         MemberInterface m_geek02 = addMember("ivana","Toulon", iutRS);
        Collection<? extends MemberInterface> membres = iutRS.getMembers();
        assertEquals("taille du reseau est bien de 2 membres", 2,membres.size());
        assertTrue(membres.contains(m_geek01));
        assertTrue(membres.contains(m_geek02));
    }
}
